/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn.elements;

import com.teamresourceful.yabn.elements.YabnType;
import com.teamresourceful.yabn.utils.ByteArrayUtils;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface YabnElement {
    public static final byte EOD = 0;

    public byte[] toData();

    default public byte[] toFullData() {
        byte[] data = new byte[]{this.getType().id};
        return ByteArrayUtils.add(data, this.toData());
    }

    public YabnType getType();

    default public boolean isNull() {
        return YabnType.NULL.equals((Object)this.getType());
    }

    @Nullable
    default public YabnElement getOrNull() {
        return this.isNull() ? null : this;
    }
}

